# NHES Shell Scripts

Basic scripts used for installing software on fresh instances of Debian based systems. 

## 📚 Different scripts

There are multiple scripts in this folder, most of them will give the user the option to install a bundle of software but some of them are more simple, like purely installing one piece of software that requires some more tweaking and finetuning.

## 📦 Basic installation

The *basic-installation.sh* installs, as the name suggest, some basic packages that I think should be installed by default in Ubuntu and some packages that I find useful in my situation. At the end of the script the user is also asked if they want to install a LAMP stack to use Ubuntu as a webserver.

Full package list:

* Net-tools
* OpenSSH-server
* RealVNC VNC Server
* Samba Server (including config for root-access)
* Omada Controller v4.2.8

The script also enables the Ubuntu Firewall and makes sure all what you need is allowed. In the end of the script it will ask if you want to install a LAMP-stack as well and it will automatically download and run the script that is mentioned below.

#### How to run this script

```shell
sudo -s && wget https://files.nhes.be/script/basic-install.sh && chmod +x basic-install.sh && bash ./basic-install.sh
```



## 🚀LAMP stack

A lamp stack is a bundle of software;

* Linux
* Apache
* MySQL
* PHP

This script will let you choose whether to install a basic and empty LAMP stack with no additional software, LAMP with Webmin and phpMyAdmin or install Bookstack, a laravel based wiki-software, the installation of which comes with a LAMP stack. This script is also used in the *basic-installation.sh*.

#### How to run this script

```shell
sudo -s
wget https://files.nhes.be/script/lamp.sh
chmod +x lamp.sh
bash ./lamp.sh
```

## 📦 Test script

#### For testing purposes an empty shell script-file is on the server, this file can be used to test out some script-lines before applying them into a script.

#### How to run this script

```shell
sudo -s
wget https://files.nhes.be/script/test.sh
chmod +x test.sh
bash ./test.sh
rm test.sh
```



## 👪 Credits

All scripts are written by Nicky Hendriks with the help of installation documentations of the used packages and the kind people at StackOverflow.