#!/bin/sh
RED='\033[0;31m'
NC='\033[0m' # No Color
ip4=$(ip route get 8.8.8.8 | sed -n '/src/{s/.*src *\([^ ]*\).*/\1/p;q}')
# This script will install a new BookStack instance on a fresh Ubuntu 20.04 server.
# This script is experimental and does not ensure any security.

# Fetch domain to use from first provided parameter,
# Otherwise request the user to input their domain
DOMAIN=$1
if [ -z $1 ]
then
echo ""
printf '\e[33mEnter the domain you want to host BookStack and press [ENTER]\nExamples: my-site.com or docs.my-site.com\ne[m'
read DOMAIN
fi

echo ""
printf '\e[33mEnter the name of the database you want to use for BookStack and press [ENTER]\nDo not use hyphens (-), instead use underscores.\n\e[m'
read DBNAME
echo ""
printf '\e[33mEnter the name of the database-user you want to use for BookStack and press [ENTER]\nDo not use hyphens (-), instead use underscores.\n\e[m'
read DBUSER
echo ""
printf '\e[33mEnter a database password you want to use for BookStack and press [ENTER]\nDo not use hyphens (-) or wildcards (*)\n\e[m'
read DBPASS
echo "\nNow converting hyphens to underscores."
echo "$DBNAME" | tr '-' '_'
echo "$DBUSER" | tr '-' '_'

# Get the current machine IP address
CURRENT_IP=$(ip addr | grep 'state UP' -A2 | tail -n1 | awk '{print $2}' | cut -f1  -d'/')

# Install core system packages
export DEBIAN_FRONTEND=noninteractive
add-apt-repository universe
apt update
apt install -y git unzip apache2 php7.4 curl php7.4-fpm php7.4-curl php7.4-mbstring php7.4-ldap \
php7.4-tidy php7.4-xml php7.4-zip php7.4-gd php7.4-mysql mysql-server-8.0 libapache2-mod-php7.4

# Set up database
mysql -u root -e "CREATE DATABASE ${DBNAME} /*\!40100 DEFAULT CHARACTER SET utf8 */;"
mysql -u root -e "CREATE USER ${DBUSER}@localhost IDENTIFIED BY '${DBPASS}';"
mysql -u root -e "GRANT ALL ON ${DBNAME}.* TO '${DBUSER}'@'localhost';"
mysql -u root -e "FLUSH PRIVILEGES;"

# Download BookStack
cd /var/www
git clone https://github.com/BookStackApp/BookStack.git --branch release --single-branch bookstack
BOOKSTACK_DIR="/var/www/bookstack"
cd $BOOKSTACK_DIR

# Install composer
EXPECTED_SIGNATURE=$(wget https://composer.github.io/installer.sig -O - -q)
curl -s https://getcomposer.org/installer > composer-setup.php
ACTUAL_SIGNATURE=$(php -r "echo hash_file('SHA384', 'composer-setup.php');")

if [ "$EXPECTED_SIGNATURE" = "$ACTUAL_SIGNATURE" ]
then
    php composer-setup.php --quiet
    RESULT=$?
    rm composer-setup.php
else
    >&2 echo 'ERROR: Invalid composer installer signature'
    rm composer-setup.php
    exit 1
fi

# Install BookStack composer dependencies
php composer.phar install --no-dev

# Copy and update BookStack environment variables
cp .env.example .env
sed -i "s/APP_URL=.*/APP_URL=http:\/\/$DOMAIN/g" .env
sed -i "s/DB_DATABASE=.*/DB_DATABASE=$DBNAME/g" .env
sed -i "s/DB_USERNAME=.*/DB_USERNAME=$DBUSER/g" .env
sed -i "s/DB_PASSWORD=.*/DB_PASSWORD=$DBPASS/g" .env

# Generate the application key
php artisan key:generate --no-interaction --force
# Migrate the databases
php artisan migrate --no-interaction --force

# Set file and folder permissions
chown www-data:www-data -R bootstrap/cache public/uploads storage && chmod -R 755 bootstrap/cache public/uploads storage

# Set up apache
a2enmod rewrite
a2enmod php7.4

cat >/etc/apache2/sites-available/bookstack.conf <<EOL
<VirtualHost *:80>
	ServerName ${DOMAIN}

	ServerAdmin webmaster@localhost
	DocumentRoot /var/www/bookstack/public/

    <Directory /var/www/bookstack/public/>
        Options Indexes FollowSymLinks
        AllowOverride None
        Require all granted
        <IfModule mod_rewrite.c>
            <IfModule mod_negotiation.c>
                Options -MultiViews -Indexes
            </IfModule>

            RewriteEngine On

            # Handle Authorization Header
            RewriteCond %{HTTP:Authorization} .
            RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

            # Redirect Trailing Slashes If Not A Folder...
            RewriteCond %{REQUEST_FILENAME} !-d
            RewriteCond %{REQUEST_URI} (.+)/$
            RewriteRule ^ %1 [L,R=301]

            # Handle Front Controller...
            RewriteCond %{REQUEST_FILENAME} !-d
            RewriteCond %{REQUEST_FILENAME} !-f
            RewriteRule ^ index.php [L]
        </IfModule>
    </Directory>

	ErrorLog ${APACHE_LOG_DIR}/error.log
	CustomLog ${APACHE_LOG_DIR}/access.log combined

</VirtualHost>
EOL

a2dissite 000-default.conf
a2ensite bookstack.conf

#get the latest version of BookStack
cd $BOOKSTACK_DIR
git pull origin release && composer install --no-dev && php artisan migrate
php artisan cache:clear
php artisan view:clear

# Restart apache to load new config
systemctl restart apache2
systemctl enable apache2
