#!/bin/sh
RED='\033[0;31m'
NC='\033[0m' # No Color
ip4=$(ip route get 8.8.8.8 | sed -n '/src/{s/.*src *\([^ ]*\).*/\1/p;q}')

#Start by updating all repositories and software
apt update
apt -y upgrade

#install ufw
while true; do
    read -p $'\n\e[33mWould you like to install UFW\e[0m: (y/n) ' yn
    case $yn in
        [Yy]* ) apt-get -y install ufw;
				ufw enable;
				echo $'\e[33mPackage installed\n\n \e[0m ';
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done

#install net-tools
while true; do
    read -p $'\n\e[33mWould you like to install Net-Tools\e[0m: (y/n) ' yn
    case $yn in
        [Yy]* ) apt-get -y install net-tools;
				echo $'\e[33mPackage installed\n\n \e[0m ';
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done

#install openssh
while true; do
    read -p $'\n\e[33mWould you like to install OpenSSH?\e[m (y/n) ' yn
    case $yn in
        [Yy]* ) apt-get -y install openssh-server;
				printf ${RED}"OpenSSH installed. From now on you can connect using $ip4:22 as host with the username and password set up during OS-install.\n"${NC}			
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done

#install git
while true; do
    read -p $'\n\e[33mWould you like to install git?\e[m (y/n) ' yn
    case $yn in
        [Yy]* ) apt-get -y install git;
				echo $'\e[33mPackage installed\n\n \e[0m ';
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done

#install vnc-server
while true; do
    read -p $'\n\e[33mWould you like to install VNC Server?\e[m (y/n) ' yn
    case $yn in
        [Yy]* ) wget https://www.realvnc.com/download/file/vnc.files/VNC-Server-6.7.2-Linux-x64.deb; 
				dpkg -i VNC-Server-6.7.2-Linux-x64.deb;
				echo $'\e[33mPackage installed\n\n \e[0m ';
				systemctl start vncserver-virtuald.service;
				systemctl enable vncserver-virtuald.service;
				rm VNC-Server-6.7.2-Linux-x64.deb;
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done


#install samba
while true; do
    read -p $'\n\e[33mWould you like to install Samba Server?\e[m (y/n) ' yn
    case $yn in
        [Yy]* ) apt -y install samba;
				mv /etc/samba/smb.conf /etc/samba/smb.conf.bak;
				wget https://raw.githubusercontent.com/NHendriks01/ubuntu/main/smb.conf;
				mv smb.conf /etc/samba/smb.conf;
				printf ${RED}"----------------------------\n\nTime to create a samba-user\n\n----------------------------\n"${NC};
				read -p $'\e[31mFor which user would you like to create a Samba-user?\e[0m: ' smbusername;
				smbpasswd -a $smbusername;
				sed -i "/valid users/s/userhere/$smbusername/g" /etc/samba/smb.conf;
				ufw allow 'Samba';
				service smbd enable;
				service smbd start;

				echo $'\e[33mPackage installed\n\n \e[0m ';
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done

#fix possible broken packages
apt --fix-missing install
apt -y autoremove
ufw allow 'OpenSSH'

printf ${RED}"\n\nDone. Packages installed and firewall configured accordingly.\n\n"${NC}

#install lamp-stack
while true; do
	read -p $'\e[33mWould you like to install a LAMP stack?\e[m (y/n) ' yn
    case $yn in
        [Yy]* ) wget https://files.nhes.be/script/lamp.sh
				chmod +x lamp.sh
				bash ./lamp.sh
				printf ${RED}"\n\nDone.\n\n"${NC}
				rm ./lamp.sh;
				rm ./1.sh;
				rm ./2.sh;
				rm ./3.sh
				break;;
        [Nn]* ) echo $'\e[33mNot installing LAMP stack\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done