#!/bin/sh
RED='\033[0;31m'
NC='\033[0m' # No Color
ip4=$(ip route get 8.8.8.8 | sed -n '/src/{s/.*src *\([^ ]*\).*/\1/p;q}')

#Start by updating all repositories and software
apt update
apt -y upgrade

#install net-tools
while true; do
    read -p $'\n\e[33mWould you like to install Net-Tools\e[0m: (y/n) ' yn
    case $yn in
        [Yy]* ) apt-get -y install net-tools;
				echo $'\e[33mPackage installed\n\n \e[0m ';
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done


#install git
while true; do
    read -p $'\n\e[33mWould you like to install git?\e[m (y/n) ' yn
    case $yn in
        [Yy]* ) apt-get -y install git;
				echo $'\e[33mPackage installed\n\n \e[0m ';
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done

#install samba
while true; do
    read -p $'\n\e[33mWould you like to install Samba Server?\e[m (y/n) ' yn
    case $yn in
        [Yy]* ) apt -y install samba;
				mv /etc/samba/smb.conf /etc/samba/smb.conf.bak;
				wget https://raw.githubusercontent.com/NHendriks01/ubuntu/main/smb.conf;
				mv smb.conf /etc/samba/smb.conf;
				printf ${RED}"----------------------------\n\nTime to create a samba-user\n\n----------------------------\n"${NC};
				read -p $'\e[31mEnter username of an existing user\e[0m: ' smbusername;
				smbpasswd -a $smbusername;
				cd ;
				cd /etc/samba/;
				sed -i "/valid users/s/userhere/$smbusername/g" smb.conf;
				cd ;
				service smbd start;
				service smbd enable;
				echo $'\e[33mPackage installed\n\n \e[0m ';
				break;;
        [Nn]* ) echo $'\e[33mNot installing package\e[0m '; break;;
        * ) echo $'\e[31mPlease answer yes or no (y/n)\e[0m ';;	
    esac
done

#fix possible broken packages
#apt --fix-missing install
apt -y autoremove

printf ${RED}"\n\nDone. Packages installed and configured accordingly.\n\n"${NC}

done