#!/bin/sh
RED='\033[0;31m'
NC='\033[0m' # No Color
ip4=$(ip route get 8.8.8.8 | sed -n '/src/{s/.*src *\([^ ]*\).*/\1/p;q}')

while true; do
	read -p $'\e[33mPlease pick what to install\n1. Basic LAMP stack\n2. LAMP stack including Webmin and phpMyAdmin\n3. LAMP stack including Bookstack, Webmin and phpMyAdmin\n4. Cancel installing LAMP-stack\e[m \n\n\e[0;37mPlease pick the number of your chosen installation: \e[m' yn
    case $yn in
        [1]* ) apt -y install apache2 mysql-server php libapache2-mod-php php-mysql;
				ufw allow 'Apache Full';
				apt-get --fix-missing install;
				systemctl enable apache2;
				systemctl stop apache2;
				systemctl start apache2;
				printf ${RED}"\n\nLAMP-stack installed. You can check if it is working on http://localhost/ or on http://$ip4/\n"${NC}
				break;;
		[2]* ) wget https://files.nhes.be/script/lamp-scripts/2.sh;
				chmod +x 2.sh;
				bash ./2.sh
				rm ./2.sh;
				printf ${RED}"\n\nLAMP-stack, Webmin and phpMyAdmin installed. You can check if it is working on http://localhost/ or on http://$ip4/. You still have to create a Webmin user manually and revoke all rights from root user in Webmin at http:/localhost:10000/ or http://$ip4:10000/\n\n"${NC}
				break;;
        [3]* ) wget https://files.nhes.be/script/lamp-scripts/3.sh;
				chmod +x 3.sh;
				bash ./3.sh
				rm ./3.sh;
				printf ${RED}"\n\nDone. Bookstack and related packages installed and firewall configured accordingly.\n\nAll that is left is to manually to add a user and revoke all rights from root user in Webmin at http:/localhost:10000 or http://$ip4:10000/\n\n"${NC};
				break;;
		[4]* ) echo $'\e[31mYou have cancelled.\n\n\e[0m ';
				break;;
        * ) echo $'\e[31mPlease answer 1, 2, 3 or 4.\e[0m ';;	
    esac
done

