#!/bin/sh
RED='\033[0;31m'
NC='\033[0m' # No Color

#install bookstack
wget https://files.nhes.be/script/lamp-scripts/bookstack-install.sh
chmod a+x bookstack-install.sh
./bookstack-install.sh
rm ./bookstack-install.sh

#allow apache ufw
ufw allow 'Apache Full'
ufw allow 10000

#install webmin
apt-get -y install perl libnet-ssleay-perl openssl libauthen-pam-perl libpam-runtime libio-pty-perl apt-show-versions python unzip
wget http://prdownloads.sourceforge.net/webadmin/webmin_1.962_all.deb
dpkg --install webmin_1.962_all.deb
/etc/init.d/webmin start


#install phpmyadmin
apt-get -y install phpmyadmin 

#fix possible broken packages
apt-get --fix-missing install

#enable Apache2
systemctl enable apache2
systemctl reload apache2
systemctl restart apache2

echo ""
echo '\e[33mSetup Finished, Your BookStack instance should now be installed.\e[m'
echo '\e[33mYou can login with the email "admin@admin.com" and password of "password"\e[m'
echo '\e[33mMySQL was installed without a root password, It is recommended that you set a root MySQL password.\e[m'
echo ""
echo '\e[33mYou can access your BookStack instance at: http://$CURRENT_IP/ or http://$DOMAIN/\e[m'